/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.secureftp.internal;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.TimeZoneUtil;
import com.aptana.filesystem.secureftp.IFTPSConnectionPoint;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ui.ftp.internal.IOptionsComposite;
import com.aptana.ui.ftp.internal.NumberVerifyListener;
import com.aptana.ui.secureftp.internal.Messages;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.TimeZone;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FTPSAdvancedOptionsComposite
extends Composite
implements IOptionsComposite {
    private static final String EMPTY = "";
    private IOptionsComposite.IListener listener;
    private Combo securityMethodCombo;
    private Button validateCertificateCheckbox;
    private Button noSSLSessionResumptionCheckbox;
    private Combo modeCombo;
    private Text portText;
    private Combo encodingCombo;
    private Combo timezoneCombo;
    private Button detectButton;
    private ModifyListener modifyListener;

    public FTPSAdvancedOptionsComposite(Composite parent, int style, IOptionsComposite.IListener listener) {
        super(parent, style);
        this.listener = listener;
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(5).spacing(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(4), new PixelConverter((Control)this).convertVerticalDLUsToPixels(4)).create());
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.FTPSAdvancedOptionsComposite_SSLMethod));
        this.securityMethodCombo = new Combo((Composite)this, 2060);
        this.securityMethodCombo.add(Messages.FTPSAdvancedOptionsComposite_MethodExplicit);
        this.securityMethodCombo.add(Messages.FTPSAdvancedOptionsComposite_MethodImplicit);
        this.securityMethodCombo.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.securityMethodCombo.computeSize((int)-1, (int)-1, (boolean)true).x, -1).span(3, 1).create());
        this.validateCertificateCheckbox = new Button((Composite)this, 32);
        this.validateCertificateCheckbox.setText(Messages.FTPSAdvancedOptionsComposite_ValidateCertificate);
        this.validateCertificateCheckbox.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().span(4, 1).create());
        this.noSSLSessionResumptionCheckbox = new Button((Composite)this, 32);
        this.noSSLSessionResumptionCheckbox.setText(Messages.FTPSAdvancedOptionsComposite_NoSSLSessionResumption);
        this.noSSLSessionResumptionCheckbox.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.FTPSAdvancedOptionsComposite_ConnectMode));
        this.modeCombo = new Combo((Composite)this, 2060);
        this.modeCombo.add(Messages.FTPSAdvancedOptionsComposite_ModeActive);
        this.modeCombo.add(Messages.FTPSAdvancedOptionsComposite_ModePassive);
        this.modeCombo.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.modeCombo.computeSize((int)-1, (int)-1, (boolean)true).x, -1).create());
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).hint(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(55), -1).create());
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label.setText(StringUtil.makeFormLabel((String)Messages.FTPSAdvancedOptionsComposite_Port));
        this.portText = new Text((Composite)this, 133124);
        this.portText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(Math.max(new PixelConverter((Control)this.portText).convertWidthInCharsToPixels(5), this.portText.computeSize((int)-1, (int)-1, (boolean)true).x), -1).create());
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.FTPSAdvancedOptionsComposite_Encoding));
        this.encodingCombo = new Combo((Composite)this, 2060);
        this.encodingCombo.setItems(Charset.availableCharsets().keySet().toArray(ArrayUtil.NO_STRINGS));
        this.encodingCombo.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.encodingCombo.computeSize((int)-1, (int)-1, (boolean)true).x, -1).span(4, 1).create());
        Composite container = new Composite((Composite)this, 0);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(5, 1).create());
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        label = new Label(container, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.FTPSAdvancedOptionsComposite_Timezone));
        this.timezoneCombo = new Combo(container, 2060);
        Object[] timezones = TimeZone.getAvailableIDs();
        Arrays.sort(timezones);
        this.timezoneCombo.setItems((String[])timezones);
        this.timezoneCombo.add(EMPTY, 0);
        this.timezoneCombo.setLayoutData((Object)GridDataFactory.swtDefaults().hint(this.timezoneCombo.computeSize((int)-1, (int)-1, (boolean)true).x, -1).create());
        this.detectButton = new Button(container, 8);
        this.detectButton.setText(Messages.FTPSAdvancedOptionsComposite_Detect);
        this.detectButton.setLayoutData((Object)GridDataFactory.fillDefaults().hint(Math.max(new PixelConverter((Control)this.detectButton).convertHorizontalDLUsToPixels(61), this.detectButton.computeSize((int)-1, (int)-1, (boolean)true).x), -1).create());
        this.addListeners();
        this.securityMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FTPSAdvancedOptionsComposite.this.securityMethodCombo.getSelectionIndex() == 0) {
                    FTPSAdvancedOptionsComposite.this.portText.setText(Integer.toString(21));
                } else {
                    FTPSAdvancedOptionsComposite.this.portText.setText(Integer.toString(990));
                }
            }
        });
        this.portText.addVerifyListener((VerifyListener)new NumberVerifyListener());
        this.detectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FTPSAdvancedOptionsComposite.this.detectTimezone();
            }
        });
    }

    public void loadPropertiesFrom(Object element) {
        Assert.isLegal((boolean)(element instanceof IFTPSConnectionPoint));
        IFTPSConnectionPoint ftpsConnectionPoint = (IFTPSConnectionPoint)element;
        this.removeListeners();
        try {
            this.securityMethodCombo.select(ftpsConnectionPoint.isExplicit() ? 0 : 1);
            this.validateCertificateCheckbox.setSelection(ftpsConnectionPoint.isValidateCertificate());
            this.noSSLSessionResumptionCheckbox.setSelection(ftpsConnectionPoint.isNoSSLSessionResumption());
            this.modeCombo.select(ftpsConnectionPoint.isPassiveMode() ? 1 : 0);
            this.portText.setText(Integer.toString(ftpsConnectionPoint.getPort()));
            int index = this.encodingCombo.indexOf(String.valueOf(ftpsConnectionPoint.getEncoding()));
            if (index >= 0) {
                this.encodingCombo.select(index);
            }
            if ((index = this.timezoneCombo.indexOf(String.valueOf(ftpsConnectionPoint.getTimezone()))) >= 0) {
                this.timezoneCombo.select(index);
            } else {
                this.timezoneCombo.select(this.timezoneCombo.indexOf(EMPTY));
            }
        }
        finally {
            this.addListeners();
        }
    }

    public boolean savePropertiesTo(Object element) {
        String timezone;
        boolean passiveMode;
        boolean explicit;
        Assert.isLegal((boolean)(element instanceof IFTPSConnectionPoint));
        boolean updated = false;
        IFTPSConnectionPoint ftpsConnectionPoint = (IFTPSConnectionPoint)element;
        boolean bl = explicit = this.securityMethodCombo.getSelectionIndex() == 0;
        if (ftpsConnectionPoint.isExplicit() != explicit) {
            ftpsConnectionPoint.setExplicit(explicit);
            updated = true;
        }
        boolean validate = this.validateCertificateCheckbox.getSelection();
        if (ftpsConnectionPoint.isValidateCertificate() != validate) {
            ftpsConnectionPoint.setValidateCertificate(validate);
            updated = true;
        }
        boolean noResumption = this.noSSLSessionResumptionCheckbox.getSelection();
        if (ftpsConnectionPoint.isNoSSLSessionResumption() != noResumption) {
            ftpsConnectionPoint.setNoSSLSessionResumption(noResumption);
            updated = true;
        }
        boolean bl2 = passiveMode = this.modeCombo.getSelectionIndex() == 1;
        if (ftpsConnectionPoint.isPassiveMode() != passiveMode) {
            ftpsConnectionPoint.setPassiveMode(passiveMode);
            updated = true;
        }
        int port = Integer.parseInt(this.portText.getText());
        if (ftpsConnectionPoint.getPort() != port) {
            ftpsConnectionPoint.setPort(port);
            updated = true;
        }
        String encoding = this.encodingCombo.getItem(this.encodingCombo.getSelectionIndex());
        if (!ftpsConnectionPoint.getEncoding().equals(encoding)) {
            ftpsConnectionPoint.setEncoding(encoding);
            updated = true;
        }
        if (EMPTY.equals(timezone = this.timezoneCombo.getItem(this.timezoneCombo.getSelectionIndex()))) {
            timezone = null;
        }
        if (!(ftpsConnectionPoint.getTimezone() == timezone || timezone != null && timezone.equals(ftpsConnectionPoint.getTimezone()))) {
            ftpsConnectionPoint.setTimezone(timezone);
            updated = true;
        }
        return updated;
    }

    public String isValid() {
        int port = 0;
        try {
            port = Integer.parseInt(this.portText.getText());
        }
        catch (NumberFormatException e) {
            e.getCause();
        }
        if (port <= 0) {
            return Messages.FTPSAdvancedOptionsComposite_InvalidPort;
        }
        return null;
    }

    public void setValid(boolean valid) {
        this.detectButton.setEnabled(valid);
    }

    public void lockUI(boolean lock) {
        this.securityMethodCombo.setEnabled(!lock);
        this.validateCertificateCheckbox.setEnabled(!lock);
        this.noSSLSessionResumptionCheckbox.setEnabled(!lock);
        this.modeCombo.setEnabled(!lock);
        this.portText.setEnabled(!lock);
        this.encodingCombo.setEnabled(!lock);
        this.timezoneCombo.setEnabled(!lock);
        this.detectButton.setEnabled(!lock);
    }

    private void detectTimezone() {
        String[] tzones;
        if (!this.listener.isValid()) {
            return;
        }
        ConnectionContext context = new ConnectionContext();
        context.setBoolean("detect_timezone", true);
        if (this.listener.testConnection(context, null) && (tzones = (String[])context.get((Object)"server_timezone")) != null && tzones.length > 0) {
            int index;
            String tz = this.timezoneCombo.getItem(this.timezoneCombo.getSelectionIndex());
            if (!Arrays.asList(tzones).contains(tz) && (index = this.timezoneCombo.indexOf(tz = TimeZoneUtil.getCommonTimeZone((String[])tzones))) >= 0) {
                this.timezoneCombo.select(index);
            }
        }
    }

    protected void addListeners() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FTPSAdvancedOptionsComposite.this.listener.validate();
                }
            };
        }
        this.portText.addModifyListener(this.modifyListener);
    }

    protected void removeListeners() {
        if (this.modifyListener != null) {
            this.portText.removeModifyListener(this.modifyListener);
        }
    }
}

